/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class DrillRodItem
extends DiggerItem {
    private final TagKey<Block> extraBlocks;
    private final int tooltipCount;
    private final float attackDamage;
    private final float attackSpeed;

    public DrillRodItem(float pAttackDamageModifier, float pAttackSpeedModifier, Tier pTier, TagKey<Block> pBlocks, TagKey<Block> pExtraBlocks, Item.Properties pProperties, int tooltipCount) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, pBlocks, pProperties);
        this.extraBlocks = pExtraBlocks;
        this.tooltipCount = tooltipCount;
        this.attackDamage = pAttackDamageModifier + pTier.m_6631_();
        this.attackSpeed = pAttackSpeedModifier;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return pState.m_204336_(this.extraBlocks) ? this.f_40980_ : super.m_8102_(pStack, pState);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage + (double)(isPowerful ? 4.0f : 0.0f), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
            return multimap;
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean m_6813_(@NotNull ItemStack pStack, Level pLevel, @NotNull BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (!pLevel.f_46443_ && pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            if (pEntityLiving.m_21206_().m_204117_(Tags.Items.ENCHANTING_FUELS)) {
                pEntityLiving.m_21206_().m_41774_(1);
            } else {
                pStack.m_41622_(1, pEntityLiving, user -> user.m_21166_(EquipmentSlot.MAINHAND));
            }
            if ((double)pEntityLiving.m_21223_() > 0.7 * (double)pEntityLiving.m_21233_()) {
                if (pEntityLiving.m_21233_() < 20.0f) {
                    pEntityLiving.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 1));
                } else {
                    pEntityLiving.m_6469_(pLevel.m_269111_().m_269425_(), (float)((double)pEntityLiving.m_21223_() - 0.7 * (double)pEntityLiving.m_21233_()));
                }
            }
        }
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        HashSet ALLOWED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44981_, Enchantments.f_44982_});
        if (ALLOWED_ENCHANTMENTS.contains(enchantment)) {
            return true;
        }
        HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44962_});
        return DENIED_ENCHANTMENTS.contains(enchantment) ? false : enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        if (enchantment == Enchantments.f_44987_) {
            level += isPowerful ? 15 : 5;
        }
        if (enchantment == Enchantments.f_44982_) {
            level += isPowerful ? 10 : 4;
        }
        return level;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue() && this.tooltipCount > 0) {
            for (int i = 0; i < this.tooltipCount; ++i) {
                MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this + "." + i), (Object[])new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class DrillRodEvents {
        @SubscribeEvent
        public static void drillRodArmorShatterAttack(LivingHurtEvent event) {
            LivingEntity hurtOne = event.getEntity();
            LivingEntity attacker = event.getEntity().m_21232_();
            ItemStack toolStack = attacker != null ? attacker.m_21120_(InteractionHand.MAIN_HAND) : ItemStack.f_41583_;
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            if (!toolStack.m_41619_() && toolStack.m_41720_() instanceof DrillRodItem) {
                boolean noArmor;
                boolean bl = noArmor = !hurtOne.m_6844_(EquipmentSlot.HEAD).m_41619_() || !hurtOne.m_6844_(EquipmentSlot.CHEST).m_41619_() || !hurtOne.m_6844_(EquipmentSlot.LEGS).m_41619_() || !hurtOne.m_6844_(EquipmentSlot.FEET).m_41619_();
                if (noArmor) {
                    event.setAmount((float)((double)event.getAmount() + (isPowerful ? 10.0 + attacker.m_21133_(Attributes.f_22281_) * 0.5 : 5.0)));
                    hurtOne.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50 + hurtOne.m_217043_().m_188503_(11), 3));
                } else if (hurtOne.m_21230_() > 10) {
                    event.setAmount((float)((double)event.getAmount() + (isPowerful ? 15.0 + attacker.m_21133_(Attributes.f_22281_) * 0.75 : 7.5)));
                }
            }
        }

        @SubscribeEvent
        public static void onKnifeKnockback(LivingKnockBackEvent event) {
            double resistance;
            ItemStack toolStack;
            LivingEntity backOne = event.getEntity();
            LivingEntity attacker = event.getEntity().m_21232_();
            ItemStack itemStack = toolStack = attacker != null ? attacker.m_21120_(InteractionHand.MAIN_HAND) : ItemStack.f_41583_;
            if (!toolStack.m_41619_() && toolStack.m_41720_() instanceof DrillRodItem && (resistance = backOne.m_21133_(Attributes.f_22278_)) < 1.0) {
                float extractKnockback = 1.0f / (1.0f - (float)resistance) > 4.0f ? 4.0f : 1.0f / (1.0f - (float)resistance);
                event.setStrength(event.getOriginalStrength() + extractKnockback);
            }
        }
    }
}

